Ship = class(Item)

function Ship:init(params)
    self.id = params.id
    self.m = mesh()
    self.m.texture =("Tyrian Remastered:Ship B")
    self.m:addRect(0,0,21,27)
    self.body = physics.body(CIRCLE, 18)
    self.body.position = params.pos
    self.body.angularDamping = 4
    self.body.linearDamping = 4
    self.body.info = {ship=self}   
    self.tq = {}
end

function Ship:fire()
    Bullet(self)
end

function Ship:draw()
    pushMatrix()    
    translate(self.body.x, self.body.y)
    rotate(-self.body.angle)
    self.m:draw()
    popMatrix()
    
    if self.ttl then
        local d = 10
        local p = self.body.position +
                  vec2(math.random(-d,d),math.random(-d,d))
        Explosion(p, math.random(10,50))
    end
    
    if self.child and #self.tq>0 then
        local touch, time, childIter = table.unpack(self.tq[1])
        if ElapsedTime > time+.05 then
            table.remove(self.tq, 1)
            self.child:touched(touch, childIter)
        end
    end
end

function Ship:touched(touch, childIter)
    if not self.body then return end
    if touch.state == BEGAN then
        if touch.x < 100 and touch.y < 100 then self:fire() end
    end
    
    if touch.state == MOVING then
        local dv = vec2(touch.deltaX, touch.deltaY)
        local rv = math.random(10, 18) * 0.1
        print(rv)
        self.body.linearVelocity = (dv*50*rv)
        if dv:len() > 1 then
            self:setDir((self:getDir() + dv:normalize()*2):normalize())
        end
    end
    self.child = childIter()
    if self.child then
        table.insert(self.tq, {touch, ElapsedTime, childIter})
    end
end

function Ship:moving()
    return #self.tq>0
end

